<?php
/**
 * Created by Green Studio.
 * File: File.class.php
 * User: Timothy Zhang
 * Date: 14-1-31
 * Time: 下午2:53
 */
class Sms
{
    private $username;
    private $password;
    private $api;
    private $errNo = array(
        "0" => "短信发送成功",
        "-1" => "参数不全",
        "-2" => "服务器空间不支持,请确认支持curl或者fsocket，联系您的空间商解决或者更换空间！",
        "30" => "密码错误",
        "40" => "账号不存在",
        "41" => "余额不足",
        "42" => "帐户已过期",
        "43" => "IP地址限制",
        "50" => "内容含有敏感词"
    );

    public function __construct($username, $password)
    {

        $this->username = $username;
        $this->password = $password;
        $this->api = 'http://vip.veesing.com/smsApi/verifyCode/v2';
    }

    public function getError($no)
    {
        return $this->errNo[$no];
    }

    public function sendSms($mobile, $sms_content)
    {
        if (empty($mobile) || empty($sms_content)) {
            return false;
        }
        $sms_content = urlencode($sms_content);
        $sendUrl = $this->api . '&appId=' . $this->username . '&appKey=' . $this->password . '&phone=' .$mobile . '&content=' . $sms_content;
        $sendNo = file_get_contents($sendUrl);
        if (!$sendNo=='1') {
            return $this->getError($sendNo);
        }else{
			return '0';
		}

    }
}