<?php

defined('IN_CART') or die;

require_once COMMONPATH . "/http.class.php";

/**
 *
 *
 * 短信发送类
 *
 */
class Sms {
	
	protected $http;	//http访问类
	
	protected $url		= "http://vip.veesing.com"; //sms短信接口
	
	protected $smsphone	= ""; //sms登录手机号

	protected $smspass	= "";//sms登录密码

	protected $smssign	= "";//sms签名
	
	protected $error		= "";
	/**
	 *
	 *
	 * 构造函数
	 *
	 */
	public function __construct($smsphone = "",$smspass = "",$smssign = "") {
		$this->http = new Http();
		$this->smsphone = $smsphone;
		$this->smspass  = md5($smspass);
		$this->smssign  = $smssign;
	}
	
	/**
	 *
	 *
	 * 验证用户是否正确，如果正确，返回用户信息，
	 *
	 */
	public function getUser() {
		if(!$this->smsphone || !$this->smspass) return null;
		$ret = $this->xml_to_array($this->http->post($this->url . "/smsApi/verifyCode/getBalance",array("appId"=>$this->smsphone, "appKey"=>$this->smspass)));
		return $ret['GetNumResult']['num'];
	}
	
	/**
	 *
	 *
	 * 发送短信
	 *
	 */
	public function send($phone,$content) {
		if(!$this->smsphone || !$this->smspass) return null;
		$ret =$this->xml_to_array($this->http->post($this->url. "/smsApi/verifyCode/v2",array("appId"=>$this->smsphone,"appKey"=>$this->smspass,"phone"=>$phone,"content"=>$content)));
		
		if($ret['SubmitResult']['code'] == 2) {
			return true;
		}else{
			$this->error = $ret['SubmitResult']['msg'];
		}
		return false;
	}

	//将 xml数据转换为数组格式。
	private function xml_to_array($xml)
	{
		$reg = "/<(\w+)[^>]*>([\\x00-\\xFF]*)<\\/\\1>/";
		if (preg_match_all($reg, $xml, $matches)) {
			$count = count($matches[0]);
			for ($i = 0; $i < $count; $i++) {
				$subxml = $matches[2][$i];
				$key = $matches[1][$i];
				if (preg_match($reg, $subxml)) {
					$arr[$key] = $this->xml_to_array($subxml);
				} else {
					$arr[$key] = $subxml;
				}
			}
		}
		return $arr;
	}
	
	/**
	 *
	 *
	 * 发送短信
	 *
	 */
	public function getError() {
		return $this->error;
	} 
}