<?php

namespace addons\veesing\library;

class Veesing
{
    private $_params = [];
    protected $error = '';
    protected static $instance = null;
    protected $config = [];

    public function __construct($options = [])
    {
        if ($config = get_addon_config('veesing')) {
            $this->config = array_merge($this->config, $config);
        }
        $this->config = array_merge($this->config, is_array($options) ? $options : []);
    }

    /**
     * 单例
     * @param array $options 参数
     * @return Smsbao
     */
    public static function instance($options = [])
    {
        if (is_null(self::$instance)) {
            self::$instance = new static($options);
        }
        return self::$instance;
    }

    /**
     * 立即发送短信
     *
     * @return boolean
     */
    public function send()
    {
        $this->error = '';
        $params = $this->_params();
        $post_data = array(
            'appId' => $this->config['apiid'],
            'appKey' => $this->config['apikey'],
            'phone' => $params['mobile'],
            'content' => $params['msg']
        );
        $url = "http://vip.veesing.com/smsApi/verifyCode/v2";
        $get = $this->_https_request($url,$post_data);
        $gets =  $this->xml_to_array($get);
        if($gets['SubmitResult']['code']!=2){
            $this->error = $gets['SubmitResult']['msg'].' 短信发送失败，请联系服务商！';
            return FALSE;
        } else {
            return TRUE;
        }
        return FALSE;
    }

    public function xml_to_array($xml){
        $reg = "/<(\w+)[^>]*>([\\x00-\\xFF]*)<\\/\\1>/";
        if(preg_match_all($reg, $xml, $matches)){
            $count = count($matches[0]);
            for($i = 0; $i < $count; $i++){
            $subxml= $matches[2][$i];
            $key = $matches[1][$i];
                if(preg_match( $reg, $subxml )){
                    $arr[$key] = $this->xml_to_array( $subxml );
                }else{
                    $arr[$key] = $subxml;
                }
            }
        }
        return $arr;
    }

	public function _https_request($url,$data = null){
		if(function_exists('curl_init')){
			$curl = curl_init();
		    if (is_array($data)) {
                $curlPost = http_build_query($data, '', '&');
            }
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_TIMEOUT, 10);//超时时间
            curl_setopt($curl, CURLOPT_NOBODY, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $curlPost);
		    if (strpos($url, "https") === 0){//访问SSL协议的URL https://
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // 是否验证ssl证书
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0); // 0表示不检查证书；1表示检查证书中是否有CN(common name)字段；2表示在1的基础上校验当前的域名是否与CN匹配
            }
            $return_str = curl_exec($curl);
            curl_close($curl);
            return $return_str;
		}else{
			$this->error = '短信发送失败，请开启curl服务！';
			return false;
		}
	}

    private function _params()
    {
        return array_merge([
            'apiid' => $this->config['apiid'],
            'apikey' => md5($this->config['apikey']),
        ], $this->_params);
    }

    /**
     * 获取错误信息
     * @return string
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * 接收手机
     * @param   string $mobile 手机号码
     * @return Smsbao
     */
    public function mobile($mobile = '')
    {
        $this->_params['mobile'] = $mobile;
        return $this;
    }

    /**
     * 短信内容
     * @param   string $msg 短信内容
     * @return Smsbao
     */
    public function msg($msg = '')
    {
        $this->_params['msg'] = $msg;
        return $this;
    }
}