<?php
require_once(dirname(__FILE__)."/config.php");
require_once DEDEINC.'/membermodel.cls.php';

function sendsms($mobiles, $content){
    $info   = explode(',', $mobiles);
    $appId  = $info[0];
    $appKey = $info[1];
    $mobile = $info[2];

    // 中昱维信
    $target = "http://vip.veesing.com/smsApi/verifyCode/v2";
    $post_data = http_build_query([
        "appId"   => $appId,
        "appKey"  => $appKey,
        "phone"   => $mobile,
        "content" => $content
    ]);

    $response = http_post($target, $post_data);
    $result   = json_decode($response, true);

    // 记录日志
    file_put_contents(
        dirname(dirname(__FILE__))."/sms_log_".$appId.".log",
        '发送状态：'.json_encode($result, JSON_UNESCAPED_UNICODE)."\r\n",
        FILE_APPEND
    );

    if (isset($result['returnStatus']) && $result['returnStatus'] == "1") {
        return 'ok';
    } else {
        return isset($result['message']) ? $result['message'] : '未知错误';
    }
}

function http_post($url, $data){
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

// 生成6位验证码
function getverifycode() {
    $length = 6;
    PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
    return sprintf('%0'.$length.'d', mt_rand(0, pow(10, $length) - 1));
}

// 手机号校验（可选）
function ismobile($mobile){
    return (strlen($mobile) >= 11 && preg_match("/^1\d{10}$/", $mobile));
}
?>
